
(*
** Make Soundprint
** Written by Bas van Gaalen in September '96.
**
** This program is a part of the Instrument Recognition project.
*)

program make_soundprint;

uses
  dos,_fft;

const
  infmask:pathstr='wavs\*.wav'{'?????-c4.wav'};                { Input filemask }
  outfpath:pathstr='spr\';
  dataofs=3000;
  maxidx=1024;

type
  commentstr=string[20];

var
  f:file;
  path:pathstr; name:namestr; ext:extstr;
  buf:array[1..maxidx] of byte;
  comment:commentstr;
  fname:pathstr;
  di:searchrec;
  data:datastruc;
  mag:magstruc;
  i,err:word;

function upstr(s:string):string;
var
  tmp:string;
  i:byte;
begin
  fillchar(tmp,sizeof(tmp),0);
  for i:=1 to length(s) do
    tmp[i]:=upcase(s[i]);
  tmp[0]:=s[0];
  upstr:=tmp;
end;

begin
  writeln('Making soundprints...');
  fsplit(infmask,path,name,ext);
  outfpath:=upstr(outfpath);
  findfirst(infmask,anyfile,di);
  while doserror=0 do begin
    { Find out filename to read }
    fname:=path+di.name;
    write(upstr(fname),' -> ');
    fillchar(data,sizeof(data),0);
    { Read file }
    assign(f,fname);
    reset(f,1);
    seek(f,dataofs);
    blockread(f,buf,maxidx,err);
    close(f);
    if err<>maxidx then halt(1);
    for i:=1 to maxidx do data[i].re:=buf[i];
    { Perform Fast Fourier Transform and conversion }
    fft(data,maxidx);
    convert(data,mag,maxfpr);
    { Find out new filename }
    fsplit(fname,path,name,ext);
    fname:=upstr(name+'.spr');
    fillchar(comment,sizeof(comment),1);

    {write(fname,'. Name: '); readln(comment);}
    comment:=copy(fname,1,8);
    writeln(outfpath+fname,'. Name: ',comment);

    { Write soundprint data }
    assign(f,outfpath+fname);
    rewrite(f,1);
    blockwrite(f,comment,sizeof(commentstr));
    blockwrite(f,mag,sizeof(mag));
    close(f);
    findnext(di);
  end;
  writeln('Ready...');
end.
