//
// Configuration header file for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_CONFIG_H
#define __PTC_CONFIG_H




//
// Debug build checking
// --------------------
//
// When __DEBUG__ is defined the OpenPTC implementation will
// perform runtime checking to trap bugs early. As this will
// greatly help with development of a new implementation it
// is currently enabled.
//
// When you release your implementation you should comment out
// the define below to increase performance. Alternatively you
// could provide a seperate debug and release library for your
// users and have __DEBUG__ defined only in the debug build.
//
#define __DEBUG__


//
// Hermes compiler configuration
// -----------------------------
//
// Did you compile Hermes with a C compiler or a C++ compiler?
//
// If you compiled with a C++ compiler, you will need to change
// the define below to #define __HERMES_CPP__ so that C++ name
// mangling is correctly handled.
//
// It has been reported that compiling Hermes with a C compiler
// is slightly faster than with a C++ compiler. This is why
// C compiled Hermes is the default.
//

// configure hermes
#define __HERMES_C__



//
// Boolean type support
// --------------------
//
// Some older compilers do not support the ANSI C++ 'bool' type.
//
// The OpenPTC 1.0 API depends on the bool type in many places.
// Without support for the bool type OpenPTC will not compile.
//
// On compilers that do not support the bool type you will have
// to comment out the define below so that the bool type gets
// emulated in 'Types.h'
//

// most compilers have bool support
#define __COMPILER_SUPPORTS_BOOL__



//
// Const cast support
// ------------------
//
// Some older compilers do not support the ANSI C++ const_cast
//
// The Hermes Interface Package depends on const_cast support
// to safely cast from const references to the non-const pointers
// that Hermes requires.
//
// On compilers that do not support const_cast you will have to
// comment out the define below so that alternate code is used
// that does not depend on const_cast.
//

// most compilers have const_cast support
#define __COMPILER_SUPPORTS_CONST_CAST__




#endif
