//
// Tiny Timer class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// package name
package tinyptc;



public class Timer implements Cloneable
{
    public Timer()
    {
        // set start time
        start = (double) System.currentTimeMillis() / 1000.0;

        // set old time
        old = start;
    }

    public double time()
    {
        // get time
        time = (double) System.currentTimeMillis() / 1000.0;

        // calculate current time
        final double current = time - start;

        // get current time
        return current;
    }

    public double delta()
    {
        // get current clock time
        final double time = (double) System.currentTimeMillis() / 1000.0;

        // calculate delta
        final double delta = time - old;

        // update old time
        old = time;

        // get delta
        return delta;
    }

    // timer data
    private double old;
    private double time;
    private double start;
}
