//
// Tiny Format class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// package name
package tinyptc;



public class Format
{
    public Format(int bits)
    {
        // indexed color
        this.bits = 8;
    }

    public Format(int bits,int r,int g,int b)
    {
        // direct color
        this.bits = 32;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public Format(int bits,int r,int g,int b,int a)
    {
        // direct color
        this.bits = 32;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public int r()
    {
        // get r
        return r;
    }

    public int g()
    {
        // get g
        return g;
    }

    public int b()
    {
        // get b
        return b;
    }

    public int a()
    {
        // get a
        return a;
    }

    public int bits()
    {
        // get bits
        return bits;
    }

    public int bytes()
    {
        // get bytes
        return bits/8;
    }

    public boolean direct()
    {
        // is direct color?
        if (bits==32) return true;
        else return false;
    }

    public boolean indexed()
    {
        // is indexed color?
        return !direct();
    }

    // format data
    private int r;
    private int g;
    private int b;
    private int a;
    private int bits;
}
