//
// RNI Copy class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// package name
package ptc.rni;

// class imports
import ptc.Error;
import ptc.Color;
import ptc.Format;
import ptc.Palette;



public class Copy implements ptc.base.Copy
{
    public Copy() throws Error
    {
        // create
        create();
    }
    
    protected void finalize() throws Error
    {
        // destroy
        destroy();
    }

    // native methods
    private native void create() throws Error;
    private native void destroy() throws Error;
    public native void request(Format source,Format destination) throws Error;
    public native void palette(Palette source,Palette destination) throws Error;
    public native void copy(Object source_pixels,int source_x,int source_y,int source_width,int source_height,int source_pitch,Object destination_pixels,int destination_x,int destination_y,int destination_width,int destination_height,int destination_pitch) throws Error;
    public native boolean option(String option) throws Error;
}
