//
// Java Keyboard class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// package name
package ptc.java;

// import classes
import ptc.Key;
import ptc.Error;
import java.awt.event.KeyEvent;
import java.awt.event.KeyAdapter;



public class Keyboard extends KeyAdapter
{
    public Keyboard()
    {
        // defaults
        key = false;
  code = Key.UNDEFINED;
    }

    public boolean key()
    {
        // check key
        return key;
    }

    public Key read()
    {
        // wait for key press
        while (!key());

        // create key object
  Key key = new Key(code);

        // clear data
        this.key = false;
  this.code = Key.UNDEFINED;

        // return key
        return key;
    }

    public void keyPressed(KeyEvent event)
    {
        // keypress
        key = true;
  code = event.getKeyCode();
    }

    // keyboard data
 private int code;
    private boolean key;
}
