//
// Java Frame class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// package name
package ptc.java;

// import classes
import java.awt.Point;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Graphics;
import java.awt.Container;
import java.awt.Dimension;



public class Frame extends java.awt.Frame
{
    public Frame(Window window,String title,int width,int height)
    {
        // create frame
        super(title);
       
        // setup window
        this.window = window;

        // set window size
        setSize(width,height);

        // set black background
        setBackground(Color.black);

        // move window offscreen
        setLocation(-width*2,-height*2);

        // show
        show();

        // set client area
        client(width,height);

        // center
        center();

        // set client area
        client(width,height);

        // add window listener
        addWindowListener(new Listener());
    }

    /*
    public synchronized void repaint()
    {
        // paint window
    }

    public synchronized void repaint(int x,int y,int width,int height)
    {
        // paint window
    }

    public synchronized void repaint(long tm)
    {
        // paint window
    }

    public synchronized void repaint(long tm,int x,int y,int width,int height)
    {
        // paint window
    }
    */

    public synchronized void update(Graphics graphics)
    {
        // paint window
        window.paint(graphics);
    }

    public synchronized void paint(Graphics graphics)
    {
        // paint window
        window.paint(graphics);
    }
    
    public synchronized void paintAll(Graphics graphics)
    {
        // paint window
        window.paint(graphics);
    }

    private void client(int width,int height)
    {
        // get window insets
        Insets insets = getInsets();

        // calculate size of window around client area
        final int x = width+insets.left+insets.right;
        final int y = height+insets.top+insets.bottom;

        // set size
        setSize(x,y);
    }

    private void center()
    {
        // get default awt toolkit
        Toolkit toolkit = Toolkit.getDefaultToolkit();

        // get size of window
        Dimension window = getSize();

        // get size of screen
        Dimension screen = toolkit.getScreenSize();

        // calculate center x and y
        final int x = (screen.width - window.width) / 2;
        final int y = (screen.height - window.height) / 2;

        // center component
        setLocation(x,y);
    }

    // frame data
    Window window;
}
