//
// Palette class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// package
package ptc;



public class Palette implements Cloneable
{
    public Palette()
    {
        // clear locked flag
        locked = false;
    }

    public Palette(int data[])
    {
        // clear locked flag
        locked = false;

        // load data
        load(data);
    }

    protected void finalize() throws Error
    {
        // check if palette is locked
        if (locked) throw new Error("palette is still locked");
    }

    public int[] lock() throws Error
    {
        // check locked flag
        if (locked) throw new Error("palette is already locked");

        // set locked flag
        locked = true;

        // lock palette
        return data;
    }

    public void unlock() throws Error
    {
        // check locked flag
        if (!locked) throw new Error("palette is not locked");

        // reset locked flag
        locked = false;
    }

    public void load(int data[])
    {
        // load palette data
        System.arraycopy(data,0,this.data,0,256);
    }

    public void save(int data[])
    {
        // save palette data
        System.arraycopy(this.data,0,data,0,256);
    }
    
    public int[] data()
    {
        // get data array clone
        return (int[]) data.clone();
    }

    public Palette copy()
    {
        try
        {
            // clone palette object
            return (Palette) clone();
        }
        catch (CloneNotSupportedException e)
        {
            // failure
            return null;
        }
    }

    public boolean compare(Palette palette)
    {
        // compare palette object data arrays
        for (int i=0; i<256; i++) if (data[i]!=palette.data[i]) return false;

        // success
        return true;
    }

    // palette data
    private boolean locked;
    private int data[] = new int[256];
}
