//
// Clipper class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// package
package ptc;



public class Clipper
{
    public static Area clip(Area area,Area clip)
    {
        // setup clipped area
        Area clipped = area.copy();

        // clip left
        if (clipped.left<clip.left)  clipped.left = clip.left;
        if (clipped.left>clip.right) clipped.left = clip.right;
    
        // clip top
        if (clipped.top<clip.top)    clipped.top = clip.top;
        if (clipped.top>clip.bottom) clipped.top = clip.bottom;

        // clip right
        if (clipped.right<clip.left)  clipped.right = clip.left;
        if (clipped.right>clip.right) clipped.right = clip.right;
    
        // clip bottom
        if (clipped.bottom<clip.top)    clipped.bottom = clip.top;
        if (clipped.bottom>clip.bottom) clipped.bottom = clip.bottom;

        // clipped area
        return clipped;
    }

    public static void clip(Area source,Area clip_source,Area clipped_source,Area destination,Area clip_destination,Area clipped_destination)
    {
        // setup clipped source area
        float clipped_source_left   = source.left;
        float clipped_source_top    = source.top;
        float clipped_source_right  = source.right;
        float clipped_source_bottom = source.bottom;

        // clip source left
        if (clipped_source_left<clip_source.left)  clipped_source_left = clip_source.left;
        if (clipped_source_left>clip_source.right) clipped_source_left = clip_source.right;
    
        // clip source top
        if (clipped_source_top<clip_source.top)    clipped_source_top = clip_source.top;
        if (clipped_source_top>clip_source.bottom) clipped_source_top = clip_source.bottom;

        // clip source right
        if (clipped_source_right<clip_source.left)  clipped_source_right = clip_source.left;
        if (clipped_source_right>clip_source.right) clipped_source_right = clip_source.right;
    
        // clip source bottom
        if (clipped_source_bottom<clip_source.top)    clipped_source_bottom = clip_source.top;
        if (clipped_source_bottom>clip_source.bottom) clipped_source_bottom = clip_source.bottom;

        // check for early source area clipping exit
        if (clipped_source_left==clipped_source_right || clipped_source_bottom==clipped_source_top)
        {
            // clipped area is zero
            clipped_source.left   = 0;
            clipped_source.top    = 0;
            clipped_source.right  = 0;
            clipped_source.bottom = 0;
            clipped_destination.left   = 0;
            clipped_destination.top    = 0;
            clipped_destination.right  = 0;
            clipped_destination.bottom = 0;
            return;
        }

        // calculate deltas in source clip
        final float source_delta_left   = clipped_source_left   - source.left;
        final float source_delta_top    = clipped_source_top    - source.top;
        final float source_delta_right  = clipped_source_right  - source.right;
        final float source_delta_bottom = clipped_source_bottom - source.bottom;

        // calculate ratio of source area to destination area
        final float source_to_destination_x = (float) destination.width()  / (float) source.width();
        final float source_to_destination_y = (float) destination.height() / (float) source.height();

        // setup adjusted destination area
        final float adjusted_destination_left   = destination.left   + source_delta_left   * source_to_destination_x;
        final float adjusted_destination_top    = destination.top    + source_delta_top    * source_to_destination_y;
        final float adjusted_destination_right  = destination.right  + source_delta_right  * source_to_destination_x;
        final float adjusted_destination_bottom = destination.bottom + source_delta_bottom * source_to_destination_y;

        // setup clipped destination area
        float clipped_destination_left   = adjusted_destination_left;
        float clipped_destination_top    = adjusted_destination_top;
        float clipped_destination_right  = adjusted_destination_right;
        float clipped_destination_bottom = adjusted_destination_bottom;

        // clip destination left
        if (clipped_destination_left<clip_destination.left)  clipped_destination_left = clip_destination.left;
        if (clipped_destination_left>clip_destination.right) clipped_destination_left = clip_destination.right;
    
        // clip destination top
        if (clipped_destination_top<clip_destination.top)    clipped_destination_top = clip_destination.top;
        if (clipped_destination_top>clip_destination.bottom) clipped_destination_top = clip_destination.bottom;

        // clip destination right
        if (clipped_destination_right<clip_destination.left)  clipped_destination_right = clip_destination.left;
        if (clipped_destination_right>clip_destination.right) clipped_destination_right = clip_destination.right;
    
        // clip destination bottom
        if (clipped_destination_bottom<clip_destination.top)    clipped_destination_bottom = clip_destination.top;
        if (clipped_destination_bottom>clip_destination.bottom) clipped_destination_bottom = clip_destination.bottom;

        // check for early destination area clipping exit
        if (clipped_destination_left==clipped_destination_right || clipped_destination_top==clipped_destination_bottom)
        {
            // clipped area is zero
            clipped_source.left   = 0;
            clipped_source.top    = 0;
            clipped_source.right  = 0;
            clipped_source.bottom = 0;
            clipped_destination.left   = 0;
            clipped_destination.top    = 0;
            clipped_destination.right  = 0;
            clipped_destination.bottom = 0;
            return;
        }

        // calculate deltas in destination clip
        final float destination_delta_left   = clipped_destination_left   - adjusted_destination_left;
        final float destination_delta_top    = clipped_destination_top    - adjusted_destination_top;
        final float destination_delta_right  = clipped_destination_right  - adjusted_destination_right;
        final float destination_delta_bottom = clipped_destination_bottom - adjusted_destination_bottom;

        // calculate ratio of destination area to source area
        final float destination_to_source_x = 1 / source_to_destination_x;
        final float destination_to_source_y = 1 / source_to_destination_y;

        // calculate adjusted source area
        final float adjusted_source_left   = clipped_source_left   + destination_delta_left   * destination_to_source_x;
        final float adjusted_source_top    = clipped_source_top    + destination_delta_top    * destination_to_source_y;
        final float adjusted_source_right  = clipped_source_right  + destination_delta_right  * destination_to_source_x;
        final float adjusted_source_bottom = clipped_source_bottom + destination_delta_bottom * destination_to_source_y;

        // snap adjusted source area to clipped destination area
        snap(adjusted_source_left,adjusted_source_top,adjusted_source_right,adjusted_source_bottom,clipped_source);

        // snap destination area to clipped destination area
        snap(clipped_destination_left,clipped_destination_top,clipped_destination_right,clipped_destination_bottom,clipped_destination);
    }

    private static void snap(float left,float top,float right,float bottom,Area area)
    {
        // calculate floating point floors of area
        final int left_floor   = (int) Math.floor(left);
        final int top_floor    = (int) Math.floor(top);
        final int right_floor  = (int) Math.floor(right);
        final int bottom_floor = (int) Math.floor(bottom);

        // calculate floating point ceils of area
        final int left_ceil   = (int) Math.ceil(left);
        final int top_ceil    = (int) Math.ceil(top);
        final int right_ceil  = (int) Math.ceil(right);
        final int bottom_ceil = (int) Math.ceil(bottom);

        // get fractional components of area
        final float left_fraction   = left   - left_floor;
        final float top_fraction    = top    - top_floor;
        final float right_fraction  = right  - right_floor;
        final float bottom_fraction = bottom - bottom_floor;

        // snap left
        if (left_fraction>=0.5f) area.left = left_floor;
        else area.left = left_ceil;

        // snap top
        if (top_fraction>=0.5f) area.top = top_floor;
        else area.top = top_ceil;

        // snap right
        if (right_fraction<0.5f) area.right = right_floor;
        else area.right = right_ceil;

        // snap bottom
        if (bottom_fraction<0.5f) area.bottom = bottom_floor;
        else area.bottom = bottom_ceil;
    }
}
