//
// Applet example for OpenPTC 1.0 Java Implementation
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is in the public domain
//

// import classes
import ptc.Error;
import ptc.Format;
import ptc.Surface;
import ptc.java.Console;



public class Applet extends ptc.java.Applet
{
    public ptc.base.Console create() throws Error
    {
        // create format
        Format format = new Format(32,0x00FF0000,0x0000FF00,0x000000FF);

        // create console
        Console console = new Console();

        // open console on applet
        console.open(this,format);

        // return console
        return console;
    }

    public void run(ptc.base.Console console) throws Error
    {
        // create format
        Format format = new Format(32,0x00FF0000,0x0000FF00,0x000000FF);

        // get console information
        final int width  = console.width();
        final int height = console.height();

        // create surface
        Surface surface = new Surface(width,height,format);
        
        // main loop
        while (true)
        {
            // lock surface
            int pixels[] = (int[]) surface.lock();

            // draw random pixels
            for (int i=0; i<100; i++)
            {
                // get random position
                int x = random(width);
                int y = random(height);

                // get random color
                int r = random(256);
                int g = random(256);
                int b = random(256);

                // draw color [r,g,b] at position [x,y]
                pixels[x+y*width] = (r<<16) + (g<<8) + b;
            }
        
            // unlock surface
            surface.unlock();

            // copy to console
            surface.copy(console);

            // update console
            console.update();
        }
    }
    
    int random(int number)
    {
        // random number routine
        return (int) ( Math.random() * number );
    }
}
