//
// X11 Common display driver class for PTC 2.0 C++ API
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#include <X11/Xlib.h>
#include <string.h>
#include "Error.h"
#include "Format.h"
#include "Surface.h"
#include "X11Display.h"
#include "X11Image.h"
#include "Console.h"

X11Display::X11Display()
{ 
}

X11Display::~X11Display()
{ // Just close the display, everything else is done by the subclasses
  if(m_disp && !(m_flags&PTC_X11_LEAVE_DISPLAY))
  { XCloseDisplay(m_disp);
    m_disp=0;
  }
}


int X11Display::width()
{ return m_width;
}


int X11Display::height()
{ return m_height;
}


const Format& X11Display::format()
{ return m_format;
}


bool X11Display::key()
{ XEvent e;
  
  if(XCheckMaskEvent(m_disp,KeyPress,&e))
  { XPutBackEvent(m_disp,&e);             // Simulate "normal" kbhit behaviour
    return true;                          // i.e. leave the buffer intact
  }
  else
  return false;
}


int X11Display::read()
{ XEvent e;

  XMaskEvent(m_disp,KeyPress,&e);         // Blocks and waits
 
  return 1; 
}



void X11Display::load(const void *pixels,int width,int height,
  const Format& format,const int32 palette[])
{ 
  bool stretch=((int)m_width!=width)||((int)m_height!=height);

  Copy::request(format,m_format,stretch);

  Copy::palette(palette);

  // Lock and copy (lock() is hidden somewhere in that line, watch out! :)
  Copy::copy(pixels,0,0,width,height,width*format.bits()/8,
	     lock(),0,0,m_width,m_height,pitch());

  unlock();
}


void X11Display::load(const void *pixels,int width,int height,
  const Area &source,const Area &destination,const Format &format,
  const int32 palette[])
{ bool stretch=(source.width()!=destination.width())||
               (source.height()!=destination.height());

  // set copy formats
  Copy::request(format,m_format,stretch);
    
  // set copy palette
  Copy::palette(palette);

  // copy pixels to primary
  Copy::copy(pixels,source.left(),source.top(),source.width(),source.height(),
	     width*format.bits()/8,lock(),destination.left(),
	     destination.top(),destination.width(),destination.height(),
	     pitch());

  // unlock
  unlock();
}


void X11Display::save(void *pixels,int width,int height,const Format &format,
  const int32 palette[]) const
{
    // save primary pixels
    throw Error("console save is not implemented");
}


void X11Display::save(void *pixels,int width,int height,const Area &source,
  const Area &destination,const Format &format,const int32 palette[]) const
{
    // save primary pixels
    throw Error("console save is not implemented");
}


Format X11Display::getFormat(Format &format)
{
  Format tmpformat;

  // Check if our screen has the same format available. I hate how X
  // keeps bits_per_pixel and depth different

  int tmp_depth=DefaultDepth(m_disp,m_screen);
  int numfound;

  XPixmapFormatValues *pfv=XListPixmapFormats(m_disp,&numfound);
 
  for(int i=0;i<numfound;i++)
  { if(pfv[i].depth==tmp_depth)
    { tmp_depth=pfv[i].bits_per_pixel;
      break;
    }
  }

  XFree(pfv);

  
  if(tmp_depth==8 && format.indexed())
  tmpformat=Format(8);
  else
  if(tmp_depth==8 && format.direct())
  tmpformat=Format(8,0xE0,0x1C,0x3);
  else
  tmpformat=Format(tmp_depth,
		   DefaultVisual(m_disp,m_screen)->red_mask,
		   DefaultVisual(m_disp,m_screen)->green_mask,
		   DefaultVisual(m_disp,m_screen)->blue_mask);

  return tmpformat;
}


