//
// Surface class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_SURFACE_H
#define __PTC_SURFACE_H

// include files
#include "Base.h"
#include "Area.h"
#include "Copy.h"


class Surface : public BaseSurface
{
    public:

        // constructors and destructors
        Surface(int width,int height,const Format& format);
        virtual ~Surface();

        // copy
        virtual void copy(BaseSurface &surface);
	virtual void copy(BaseSurface &surface,const Area &source,
			  const Area &destination);

        // memory
        virtual void* lock();
        virtual void unlock();


        // load pixels to console
        virtual void load(const void *pixels,int width,int height,
			  const Format &format,const int32 palette[]);
        virtual void load(const void *pixels,int width,int height,
			  const Area &source,const Area &destination,
			  const Format &format,const int32 palette[]);

        // save console pixels
        virtual void save(void *pixels,int width,int height,
			  const Format &format,const int32 palette[]) const;
        virtual void save(void *pixels,int width,int height,
			  const Area &source,const Area &destination,
			  const Format &format,const int32 palette[]) const;

        // palette
        virtual void palette(int32 palette[]);

        // access
        virtual int width();
        virtual int height();
        virtual int pitch();
        virtual const Format& format();

    private:

        // data
        int m_width;
        int m_height;
        void *m_pixels;
        Format m_format;
        int32 m_palette[256];
};




#endif
