//
// X11 console implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//


// include files
#include <X11/Xlib.h>
#include <unistd.h>
#include "Error.h"
#include "Console.h"
#include "Copy.h"


static Copy *ptcopy;


Console::Console()
{
    // defaults
    x11disp = 0;
    ptcopy = Copy::Instance();
}


Console::Console(const char title[],int width,int height,Format& format,
  long flags)
{
    x11disp = 0;
    ptcopy = Copy::Instance();

    // open console
    try {
      open(title,width,height,format,flags);
    }
    catch(Error e)              // have to rethrow (error in constructor) ..
    { close();

      throw e;                  // .. and so we shall
    }
}


Console::~Console()
{
    close();
    Copy::destroy();    
}




void Console::open(const char title[],int width,int height,Format& format,
  long flags)
{
    close();

    // Check if we can open an X display
    Display *disp=XOpenDisplay(0);
    if(disp==NULL) throw Error("Cannot open X display");


    // DefaultScreen should be fine
    int screen=DefaultScreen(disp);


    // Check if nodga flag set or DGA not available
    if(!X11DGADisplay::check(width,height,disp,screen,flags))
    x11disp=new X11WindowDisplay();
#ifdef HAVE_DGA
    else
    x11disp=new X11DGADisplay();
#endif

    x11disp->flags(flags);

    x11disp->open(title,width,height,format,disp,screen);
}


void Console::open(Display *disp,int screen,Window w,Format& format,long flags)
{
  // We already have a display and a window, so we create a windowdisplay ;)
  x11disp=new X11WindowDisplay();

  x11disp->open(disp,screen,w,format);
  x11disp->flags(flags);
}

void Console::open(Display *disp,int screen,Window window,Format &format,int x,
  int y,int w,int h,long flags)
{
  x11disp=new X11WindowDisplay();
  
  x11disp->open(disp,screen,window,format,x,y,w,h);
  x11disp->flags(flags);
}

void Console::close()
{
    // close display
    if(x11disp)
    { delete x11disp;
      x11disp=0;
    }
}



void Console::copy(BaseSurface &surface)
{ throw Error("console to surface copy not implemented");
}


void Console::copy(BaseSurface &surface,const Area &source,
  const Area &destination)
{ throw Error("console to surface copy not implemented");
}


bool Console::isWindow() const
{
  if(x11disp->id()==PTC_WINDOW) return true;
  else
  return false;
}


void Console::load(const void *pixels,int width,int height,
  const Format &format,const int32 palette[])
{ x11disp->load(pixels,width,height,format,palette);
}


 void Console::load(const void *pixels,int width,int height,
  const Area &source,const Area &destination,const Format &format,
  const int32 palette[])
{ x11disp->load(pixels,width,height,source,destination,format,palette);
}


 void Console::save(void *pixels,int width,int height,
  const Format &format,const int32 palette[]) const
{ x11disp->save(pixels,width,height,format,palette);
}


 void Console::save(void *pixels,int width,int height,const Area &source,
  const Area &destination,const Format &format,const int32 palette[]) const
{ x11disp->save(pixels,width,height,source,destination,format,palette);
}


 const char* Console::name()
{ return "X11";
}

