//
// Area example: draws random pixels and copies to an area of the console
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU GPL
//

// include files
#include "ptc.h"




int main()
{
    try
    {
        // create format
        Format format(32,0x00FF0000,0x0000FF00,0x000000FF);
 
        // create console
        Console console("Area example",512,384,format);

        // create surface
        Surface surface(512,256,format);
        
        // loop until a key is pressed
        while (!console.key())
        {
            // lock surface
            int32 *pixels = (int32*) surface.lock();

            // draw random pixels
            for (int i=0; i<100; i++)
            {
                // get random position
                int x = random(512);
                int y = random(256);

                // get random color
                int r = random(256);
                int g = random(256);
                int b = random(256);

                // draw color [r,g,b] at position [x,y]
                pixels[x+y*512] = (r<<16) + (g<<8) + b;
            }
        
            // unlock surface
            surface.unlock();

            // copy surface to console area
            surface.copy(console,Area(0,0,512,256),Area(0,64,512,320));
            
            // update console (Area update is not meant as a partial update!!)
            // Use a partial copy for that. Area update is only there to speed
            // up windowed display and does NOT have an effect in DGA mode.
            console.update(Area(0,64,512,320));
        }

        // done
        return 0;
    }
    catch (Error &error)
    {
        // report error
        error.report();
    }
}
