//
// Generic C converter (from 24 bit) for the HERMES library
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#include "Conv_GC.h"

// FROM 24 BIT ROUTINES


void Hermes_GC_24rgb888_32rgb888(char8 *source,char8 *dest,unsigned int count)
{ int32 d_block;
 
  while(count--)
  {

    d_block=(((int32)*(source+R_24))<<16)|
            (((int32)*(source+G_24))<<8)|
            ((int32)*(source+B_24));
    
    *((int32 *)dest)=d_block;
 
    dest+=4;
    source+=3;
    
  }
}

void Hermes_GC_24rgb888_24rgb888(char8 *source,char8 *dest,unsigned int count)
{ int32 d_pix1,d_pix2,d_pix3;
  unsigned int i;

  for(i=0;i<count>>2;i++,dest+=12,source+=12)
  { d_pix1=READ32(source);
    d_pix2=READ32((source+4));
    d_pix3=READ32((source+8));

    WRITE32(dest,d_pix1);
    WRITE32((dest+4),d_pix2);
    WRITE32((dest+8),d_pix3);
  }
  
  for(i=0;i<(count&0x3);i++,dest+=3,source+=3)
  { *dest=*source;
    *(dest+1)=*(source+1);
    *(dest+2)=*(source+2);
  }
}


void Hermes_GC_24rgb888_24bgr888(char8 *source,char8 *dest,unsigned int count)
{ int32 d_pix1,d_pix2,d_pix3;
  char8 *c_pix1,*c_pix2,*c_pix3,tmp;
  unsigned int i;

  c_pix1=(char8 *)&d_pix1;
  c_pix2=(char8 *)&d_pix2;
  c_pix3=(char8 *)&d_pix3;

  for(i=0;i<count>>2;i++,dest+=12,source+=12)
  { d_pix1=READ32(source);
    d_pix2=READ32((source+4));
    d_pix3=READ32((source+8));

    // Swap R and B in all three pixels
    tmp=*(c_pix1+0); *(c_pix1+0)=*(c_pix1+2); *(c_pix1+2)=tmp;
    tmp=*(c_pix1+3); *(c_pix1+3)=*(c_pix2+1); *(c_pix2+1)=tmp;
    tmp=*(c_pix2+2); *(c_pix2+2)=*(c_pix3+0); *(c_pix3+0)=tmp;
    tmp=*(c_pix3+1); *(c_pix3+1)=*(c_pix3+3); *(c_pix3+3)=tmp;

    WRITE32(dest,d_pix1);
    WRITE32((dest+4),d_pix2);
    WRITE32((dest+8),d_pix3);
  }
  
  for(i=0;i<(count&0x3);i++,dest+=3,source+=3)
  { *(dest+0)=*(source+2);
    *(dest+1)=*(source+1);
    *(dest+2)=*(source+0);
  }
}


void Hermes_GC_24rgb888_16rgb565(char8 *source,char8 *dest,unsigned int count)
{ int32 d_block;
  unsigned int i;

  for(i=0;i<count>>1;i++,source+=6,dest+=4)
  { 
    d_block=((((int32)*(source+R_24))<<8)&0xf800)|
            ((((int32)*(source+G_24))<<3)&0x7e0)|
            ((((int32)*(source+B_24))>>3)&0x1f);

    d_block=d_block|
            ((((((int32)*(source+R_24+3))<<8)&0xf800)|
              ((((int32)*(source+G_24+3))<<3)&0x7e0)|
              ((((int32)*(source+B_24+3))>>3)&0x1f))<<16);

    WRITE32(dest,d_block);
  }

  if(count&1)
  {
    d_block=((((int32)*(source+R_24))<<8)&0xf800)|
            ((((int32)*(source+G_24))<<3)&0x7e0)|
            ((((int32)*(source+B_24))>>3)&0x1f);

    WRITE16(dest,(short16)d_block);
  }
}


void Hermes_GC_24rgb888_16rgb555(char8 *source,char8 *dest,unsigned int count)
{ int32 d_block;
  unsigned int i;

  for(i=0;i<count>>1;i++,source+=6,dest+=4)
  { 

    d_block=((((int32)*(source+R_24))<<7)&0x7c00)|
            ((((int32)*(source+G_24))<<2)&0x3e0)|
            ((((int32)*(source+B_24))>>3)&0x1f);

    d_block=d_block|
            ((((((int32)*(source+R_24+3))<<7)&0x7c00)|
              ((((int32)*(source+G_24+3))<<2)&0x3e0)|
              ((((int32)*(source+B_24+3))>>3)&0x1f))<<16);

    WRITE32(dest,d_block);
  }

  if(count&1)
  {
    d_block=((((int32)*(source+R_24))<<7)&0x7c00)|
            ((((int32)*(source+G_24))<<2)&0x3e0)|
            ((((int32)*(source+B_24))>>3)&0x1f);


    WRITE16(dest,(short16)d_block);
  }
}

// Generic routines from 24

void Hermes_GC_24rgb888_Generic32(char8 *source,char8 *dest,unsigned int count)
{ int32 r,g,b;

  while(count--)
  { 
    r=(int32)*(source+R_24)<<16;
    g=(int32)*(source+G_24)<<8;
    b=(int32)*(source+B_24);

    r=((r>>Hermes_GC_GI.r_right)<<Hermes_GC_GI.r_left)&
      Hermes_Generic_C.m_dest->mask_r;
    g=((g>>Hermes_GC_GI.g_right)<<Hermes_GC_GI.g_left)&
      Hermes_Generic_C.m_dest->mask_g;
    b=((b>>Hermes_GC_GI.b_right)<<Hermes_GC_GI.b_left)&
      Hermes_Generic_C.m_dest->mask_b;

    WRITE32(dest,(r|g|b));

    source+=3;
    dest+=4;
  }
}


// optimise me
void Hermes_GC_24rgb888_Generic16(char8 *source,char8 *dest,unsigned int count)
{ int32 r,g,b;
  unsigned int i;

  for(i=0;i<count;i++,source+=3,dest+=2)
  { 
    r=(int32)*(source+R_24)<<16;
    g=(int32)*(source+G_24)<<8;
    b=(int32)*(source+B_24);

    r=((r>>Hermes_GC_GI.r_right)<<Hermes_GC_GI.r_left)&
      Hermes_Generic_C.m_dest->mask_r;
    g=((g>>Hermes_GC_GI.g_right)<<Hermes_GC_GI.g_left)&
      Hermes_Generic_C.m_dest->mask_g;
    b=((b>>Hermes_GC_GI.b_right)<<Hermes_GC_GI.b_left)&
      Hermes_Generic_C.m_dest->mask_b;
    
    WRITE16(dest,(short16)(r|g|b));
  }
}


// optimise me
void Hermes_GC_24rgb888_8rgb332(char8 *source,char8 *dest,unsigned int count)
{ int32 r,g,b;
  unsigned int i;

  for(i=0;i<count;i++,source+=3,dest++)
  { 
    r=((int32)*(source+R_24))&0xe0;
    g=(((int32)*(source+G_24))>>3)&0x1c;
    b=(((int32)*(source+B_24))>>6)&0x3;

    *(dest)=(char8)(r|g|b);
  }
}

