//
// MMX converter for the HERMES library
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#include <stdio.h>
#include <stdlib.h>
#include "Hermes.h"
#include "Base.h"
#include "Conv_MMX.h"
#include "Head_MMX.h"

#ifndef NO_ASSEMBLER

static char Hermes_MMX_available;
static HermesInterface Hermes_MMX_Interface;

void Hermes_MMX_init()
{ int res;

  Hermes_MMX.m_source=(HermesFormat *)malloc(sizeof(HermesFormat));
  Hermes_MMX.m_dest=(HermesFormat *)malloc(sizeof(HermesFormat));
  Hermes_MMX.m_stretch=0;
  
  res=CheckMMX();
  printf("CPUID: %x\n",res);

  Hermes_MMX_available=(res&0x800000)?1:0;
}


void Hermes_MMX_close()
{ if(Hermes_MMX.m_source)
  { free(Hermes_MMX.m_source);
    Hermes_MMX.m_source=0;
  }

  if(Hermes_MMX.m_dest)
  { free(Hermes_MMX.m_dest);
    Hermes_MMX.m_dest=0;
  }
}


char Hermes_MMX_request(HermesFormat *source,HermesFormat *dest,char stretch)
{ char found=0;
  
  if(!Hermes_MMX_available) return 0;

  if(HermesFormatEquals(source,Hermes_MMX.m_source) &&
     HermesFormatEquals(dest,Hermes_MMX.m_dest) &&
     stretch==Hermes_MMX.m_stretch)
  return 1;

  if(stretch) return 0;

  switch(source->bpp)
  { case 32: if(source->mask_r==0xff0000 && source->mask_g==0xff00 &&
		source->mask_b==0xff)
             switch(dest->bpp)
             { case 16: /*if(dest->mask_r==0xf800 && dest->mask_g==0x7e0 &&
			   dest->mask_b==0x1f)
	                { Hermes_MMX_Interface.conv_func=ConvertMMX32_16RGB565;
			  found=1;
			}
			else*/
			if(dest->mask_r==0x7c00 && dest->mask_g==0x3e0 &&
			   dest->mask_b==0x1f)
			{ Hermes_MMX_Interface.conv_func=ConvertMMX32_16RGB555;
			  found=1;
			}

			break;
	     }
	     break;
  }

  if(found)
  { HermesFormatCopy(source,Hermes_MMX.m_source);
    HermesFormatCopy(dest,Hermes_MMX.m_dest);
    Hermes_MMX.m_stretch=stretch;

    printf("Hermes MMX Assembler Converter\n");
 
    return 1;
  }

  // Couldn't find a converter
  return 0;
}


void Hermes_MMX_palette(int32 *palette)
{
}


void Hermes_MMX_copy(void *s_pixels,int s_x,int s_y,int s_width,int s_height,
		   int s_pitch,void *d_pixels,int d_x,int d_y,int d_width,
		   int d_height,int d_pitch)
{
  Hermes_MMX_Interface.s_pixels=(char *)s_pixels;
  Hermes_MMX_Interface.s_width=s_width;
  Hermes_MMX_Interface.s_height=s_height;
  Hermes_MMX_Interface.s_add=s_pitch-s_width*Hermes_MMX.m_source->bpp/8;

  Hermes_MMX_Interface.d_pixels=(char *)d_pixels;
  Hermes_MMX_Interface.d_width=d_width;
  Hermes_MMX_Interface.d_height=d_height;
  Hermes_MMX_Interface.d_add=d_pitch-d_width*Hermes_MMX.m_dest->bpp/8;

  Hermes_MMX_Interface.s_pixels+=s_y*s_pitch+s_x*Hermes_MMX.m_source->bpp/8;
  Hermes_MMX_Interface.d_pixels+=d_y*d_pitch+d_x*Hermes_MMX.m_dest->bpp/8;

  ConvertMMX(&Hermes_MMX_Interface);
}

#endif // NO_ASSEMBLER 
