//
// Generic C definitions for the HERMES library
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//
#ifndef __HERMES_CONV_GC_H__
#define __HERMES_CONV_GC_H__

#include <stdlib.h>
#include "Base.h"

void Hermes_GC_init();

void Hermes_GC_close();

char Hermes_GC_request(HermesFormat *source,HermesFormat *dest,char stretch);

void Hermes_GC_palette(int32 *palette);

void Hermes_GC_copy(void *s_pixels,int s_x,int s_y,int s_width,int s_height,
		   int s_pitch,void *d_pixels,int d_x,int d_y,int d_width,
		   int d_height,int d_pitch);

extern BaseConverter Hermes_Generic_C;


// Help routines
void Hermes_GC_Calculate_Generic_Info(HermesFormat *format);
int Hermes_GC_topbit(int32 mask);

// Converters
extern Hermes_Generic_Info Hermes_GC_GI;


// Macros to help with conversion routines

#define READ16(adr) *((short16 *)adr)
#define READ32(adr) *((int32 *)adr)

#define WRITE16(adr,s) *((short16 *)adr)=s
#define WRITE32(adr,s) *((int32 *)adr)=s

// Macros to help with conversion to and from 24 bit

#if defined __LITTLE_ENDIAN__
  #define R_32 2                 // Position of R,G,B in a 32 bit dword
  #define G_32 1
  #define B_32 0
  #define R_24 2                 // Position of R,G,B in a 24 bit pixel
  #define G_24 1
  #define B_24 0
#elif defined __BIG_ENDIAN__
  #define R_32 1
  #define G_32 2
  #define B_32 3
  #define R_24 0
  #define G_24 1
  #define B_24 2
#else
  #error Processor endian-ness not defined!
#endif


// From 32 bit RGB
void Hermes_GC_muhmuh32_32rgb888(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_muhmuh32_32bgr888(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_muhmuh32_24rgb888(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_muhmuh32_24bgr888(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_muhmuh32_16rgb565(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_muhmuh32_16bgr565(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_muhmuh32_16rgb555(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_muhmuh32_16bgr555(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_muhmuh32_8rgb332(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_muhmuh32_Generic32(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_muhmuh32_Generic16(char8 *source,char8 *dest,unsigned int count);


// From 32 bit RGB
void Hermes_GC_32rgb888_32rgb888(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_32rgb888_32bgr888(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_32rgb888_24rgb888(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_32rgb888_24bgr888(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_32rgb888_16rgb565(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_32rgb888_16bgr565(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_32rgb888_16rgb555(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_32rgb888_16bgr555(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_32rgb888_8rgb332(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_32rgb888_Generic32(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_32rgb888_Generic16(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_Generic32_Generic32(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_Generic32_Generic24(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_Generic32_Generic16(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_Generic32_Generic8(char8 *source,char8 *dest,unsigned int count);

// From 24 bit RGB

void Hermes_GC_24rgb888_32rgb888(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_24rgb888_24rgb888(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_24rgb888_24bgr888(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_24rgb888_16rgb565(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_24rgb888_16rgb555(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_24rgb888_8rgb332(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_24rgb888_Generic32(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_24rgb888_Generic16(char8 *source,char8 *dest,unsigned int count);

// From 16 bit RGB

void Hermes_GC_16rgb565_32rgb888(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_16rgb565_32bgr888(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_16rgb565_24rgb888(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_16rgb565_24bgr888(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_16rgb565_16rgb565(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_16rgb565_16bgr565(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_16rgb565_16rgb555(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_16rgb565_16bgr555(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_16rgb565_8rgb332(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_16rgb565_Generic32(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_16rgb565_Generic16(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_Generic16_Generic32(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_Generic16_Generic24(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_Generic16_Generic16(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_Generic16_Generic8(char8 *source,char8 *dest,unsigned int count);

// From 8 bit indexed
void Hermes_GC_index8_32(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_index8_24(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_index8_16(char8 *source,char8 *dest,unsigned int count);
void Hermes_GC_index8_i8(char8 *source,char8 *dest,unsigned int count);

#endif

