//
// Fakemode Console class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_FAKEMODE_CONSOLE_H
#define __PTC_FAKEMODE_CONSOLE_H

// include files
#include "Core/Base.h"
#include "Core/Copy.h"
#include "Core/Mode.h"
#include "Core/Types.h"
#include "Core/Clear.h"
#include "Core/Format.h"
#include "Core/Config.h"
#include "Core/Palette.h"
#include "Dos/Keyboard.h"
#include "Fakemode/vga.h"


class FakemodeConsole : public BaseConsole
{
    public:

        // setup
        DLLAPI FakemodeConsole();
        DLLAPI ~FakemodeConsole();

        // console configuration
        DLLAPI virtual void PTCAPI configure(const char file[]);

        // console option string
        DLLAPI virtual bool PTCAPI option(const char option[]);

        // console modes
        DLLAPI virtual const Mode* PTCAPI modes();

        // console management
        DLLAPI virtual void PTCAPI open(const char title[],int pages = 0);
        DLLAPI virtual void PTCAPI open(const char title[],const Format &format,int pages = 0);
        DLLAPI virtual void PTCAPI open(const char title[],int width,int height,const Format &format,int pages = 0);
        DLLAPI virtual void PTCAPI open(const char title[],const Mode &mode,int pages = 0);
        DLLAPI virtual void PTCAPI close();

        // synchronization
        DLLAPI virtual void PTCAPI flush();
        DLLAPI virtual void PTCAPI finish();
        DLLAPI virtual void PTCAPI update();
        DLLAPI virtual void PTCAPI update(const Area &area);

        // keyboard input
        DLLAPI virtual bool PTCAPI key();
        DLLAPI virtual Key PTCAPI read();

        // copy to surface
        DLLAPI virtual void PTCAPI copy(BaseSurface &surface);
        DLLAPI virtual void PTCAPI copy(BaseSurface &surface,const Area &source,const Area &destination);

        // memory access
        DLLAPI virtual void* PTCAPI lock();
        DLLAPI virtual void PTCAPI unlock();

        // load pixels to console
        DLLAPI virtual void PTCAPI load(const void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette);
        DLLAPI virtual void PTCAPI load(const void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette,const Area &source,const Area &destination);

        // save console pixels
        DLLAPI virtual void PTCAPI save(void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette);
        DLLAPI virtual void PTCAPI save(void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette,const Area &source,const Area &destination);

        // clear console
        DLLAPI virtual void PTCAPI clear();
        DLLAPI virtual void PTCAPI clear(const Color &color);
        DLLAPI virtual void PTCAPI clear(const Color &color,const Area &area);

        // console palette
        DLLAPI virtual void PTCAPI palette(const Palette &palette);
        DLLAPI virtual const Palette& PTCAPI palette() const;

        // console clip area
        DLLAPI virtual void PTCAPI clip(const Area &area);

        // data access
        DLLAPI virtual int PTCAPI width() const;
        DLLAPI virtual int PTCAPI height() const;
        DLLAPI virtual int PTCAPI pages() const;
        DLLAPI virtual int PTCAPI pitch() const;
        DLLAPI virtual const Area& PTCAPI area() const;
        DLLAPI virtual const Area& PTCAPI clip() const;
        DLLAPI virtual const Format& PTCAPI format() const;
        DLLAPI virtual const char* PTCAPI name() const;
        DLLAPI virtual const char* PTCAPI title() const;
        DLLAPI virtual const char* PTCAPI information() const;


    private:

        // internal console management routines
        void internal_pre_open_setup(const char title[]);
        void internal_open_fullscreen_start();
        void internal_open_fullscreen(int width,int height,const Format &format);
        void internal_open_fullscreen_finish(int pages);
        void internal_post_open_setup();
        void internal_reset();
        void internal_close();

        // disallow copy construction
        FakemodeConsole(const FakemodeConsole &console);

        // disallow console assignment
        FakemodeConsole& operator =(const FakemodeConsole &console);

        // console debug checks
        void check_open() const;
        void check_unlocked() const;

        // data
        Mode m_modes[256];
        char m_title[1024];
        char m_information[1024];

        // flags
        bool m_open;
        bool m_locked;


        // option data
        int m_default_width;
        int m_default_height;
        int m_default_pages;
        Format m_default_format;

        int    m_fakemode_type;
        int    m_wait_retrace;

        // objects
        Copy m_copy;

        // Dos objects
        Surface *m_primary;
        DosKeyboard *m_keyboard;
        VGA     *m_vga;
};




#endif
