//
// Near memory routines for OpenPTC 1.0 C++ API Implementation [DOS extension]
// Copyright (c) 1998 Jonathan Matthew (jmatthew@uq.net.au)
// The OpenPTC 1.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_NEAR_H
#define __PTC_NEAR_H

// near pointer prototypes
inline void lock_near_base();
inline void unlock_near_base();
inline void* adjust_near_pointer(void *pointer);

#ifdef __DJGPP__

// djgpp implementation
#include <sys/nearptr.h>
#include <crt0.h>
#include <stdio.h>

extern int near_base_lock_count;

inline void lock_near_base()
{
    // increment near lock count
    near_base_lock_count++;

    // enable near pointers
    if (near_base_lock_count==1) {
        __djgpp_nearptr_enable();
    }
}

inline void unlock_near_base()
{
    // disable near pointers on last unlock
    if (near_base_lock_count==1) {
        __djgpp_nearptr_disable();
    }

    // decrememnt lock count
    near_base_lock_count--;
}

inline void* adjust_near_pointer(void *pointer)
{
    // adjust near pointer with conventional memory base
    return (void*)((unsigned int)pointer+__djgpp_conventional_base);
}


#else


inline void lock_near_base()
{
    // nothing
}

inline void unlock_near_base()
{
    // nothing
}

inline void* adjust_near_pointer(void *pointer)
{
    // no change
    return pointer;
}


#endif

#endif

