//
// Palette class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_PALETTE_H
#define __PTC_PALETTE_H

// include files
#include "Core/Copy.h"
#include "Core/Types.h"
#include "Core/Hermes.h"




class Palette
{
    public:

        // setup
        DLLAPI PTCAPI Palette();
        DLLAPI PTCAPI Palette(const int32 data[]);
        DLLAPI PTCAPI Palette(const Palette &palette);
        DLLAPI PTCAPI ~Palette();

        // memory access
        DLLAPI int32* PTCAPI lock();
        DLLAPI void PTCAPI unlock();

        // load palette data
        DLLAPI void PTCAPI load(const int32 data[]);

        // save palette data
        DLLAPI void PTCAPI save(int32 data[]) const;
        
        // get palette data
        DLLAPI const int32* PTCAPI data() const;

        // operators
        DLLAPI Palette& PTCAPI operator =(const Palette &palette);
        DLLAPI bool PTCAPI operator ==(const Palette &palette) const;
        DLLAPI bool PTCAPI operator !=(const Palette &palette) const;

    private:

        // locked flag
        bool m_locked;

        // hermes handle
        HermesHandle m_handle;

        // copy friend function
        friend void Copy::palette(const Palette &source,const Palette &destination);
};




#endif
