//
// Configuration header file for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_CONFIG_H
#define __PTC_CONFIG_H




//
// Do you want build a dynamic library?
// ------------------------------------
//
//#define __BUILD_PTC_DYNAMIC_LIBRARY__


// debug checking
#ifdef _DEBUG
#define __DEBUG__
#endif


#ifdef __BUILD_PTC_DYNAMIC_LIBRARY__

    // dynamic library
    #ifdef DYNAMIC_API
    #define DLLAPI __declspec(dllexport)
    #else
    #define DLLAPI __declspec(dllimport)
    #endif

#else

    // static library
    #define DLLAPI

#endif


// ptc api convention
//#define PTCAPI __stdcall
#define PTCAPI


// configure hermes
#define __HERMES_C__


// compiler has boolean type support
#define __COMPILER_SUPPORTS_BOOL__


// compiler has const_cast support
//#define __COMPILER_SUPPORTS_CONST_CAST__




#endif
