//
// Clear class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_CLEAR_H
#define __PTC_CLEAR_H

// include files
#include "Core/Index.h"
#include "Core/Types.h"
#include "Core/Hermes.h"
#include "Core/Config.h"




class Clear
{
    public:

        // setup
        DLLAPI PTCAPI Clear();
        DLLAPI PTCAPI ~Clear();

        // request clear
        DLLAPI void PTCAPI request(const Format &format);

        // clear pixels
        DLLAPI void PTCAPI clear(void *pixels,int x,int y,int width,int height,int pitch,const Color &color);

    private:

        // calculate mask maximum
        int32 maximum(int32 mask);

        // disallow copy construction
        Clear(const Clear &clear);

        // disallow assignment
        Clear& operator =(const Clear &clear);

        // hermes clear handle
        HermesHandle m_handle;

        // current format
        Format *m_format;

        // color data
        int32 m_maximum_r;
        int32 m_maximum_g;
        int32 m_maximum_b;
        int32 m_maximum_a;
        int32 m_maximum_index;
};




#endif
