//
// Core Surface class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_CORE_SURFACE_H
#define __PTC_CORE_SURFACE_H

// include files
#include "Core/Index.h"
#include "Core/Format.h"
#include "Base/Surface.h"




namespace ptc
{
    namespace Core
    {
        class Surface : public Base::Surface
        {
            public:

                // constructors and destructors
                Surface(int width,int height,const Base::Format &format);
                virtual ~Surface();

                // copy to surface
                virtual void copy(Base::Surface &surface);
                virtual void copy(Base::Surface &surface,const Base::Area &source,const Base::Area &destination);

                // memory access
                virtual void* lock();
                virtual void unlock();

                // load pixels to surface
                virtual void load(const void *pixels,int width,int height,const Base::Format &format,const int32 palette[]);
                virtual void load(const void *pixels,int width,int height,const Base::Format &format,const int32 palette[],const Base::Area &area);

                // save surface pixels
                virtual void save(void *pixels,int width,int height,const Base::Format &format,const int32 palette[]) const;
                virtual void save(void *pixels,int width,int height,const Base::Format &format,const int32 palette[],const Base::Area &area) const;

                // set palette
                virtual void palette(const int32 palette[]);

                // access
                virtual int width();
                virtual int height();
                virtual int pitch();
                virtual const Base::Format& format();

            private:

                // data
                int m_width;
                int m_height;
                void *m_pixels;
                Format m_format;
                int32 m_palette[256];
        };
    }
}
 



#endif
