//
// Core random routines for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_CORE_RANDOM_H
#define __PTC_CORE_RANDOM_H

// include files
#include <time.h>
#include <math.h>
#include <stdlib.h>




namespace ptc
{
    namespace Core
    {
        inline void randomize() 
        { 
            srand((unsigned)time(0));
        }

        inline int random(int max)
        {
            float n=(float)rand()/((float)(RAND_MAX));
            int val=(int)floor(n*max);
            if (val>=max) val=max-1;
            return val;
        }
    }
}




#endif
