//
// Format interface for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_BASE_FORMAT_H
#define __PTC_BASE_FORMAT_H

// include files
#include "Base/Types.h"




namespace ptc
{
    namespace Base
    {
        class Format
        {
            public:

                // data access
                virtual int32 r() const = 0;
                virtual int32 g() const = 0;
                virtual int32 b() const = 0;
                virtual int32 a() const = 0;
                virtual int bits() const = 0;
                virtual bool direct() const  = 0;
                virtual bool indexed() const = 0;

                // operators
                virtual Format& operator =(const Format &other)     = 0;
                virtual bool operator ==(const Format &other) const = 0;
                virtual bool operator !=(const Format &other) const = 0;
        };
    }
}




#endif
