//
// Surface interface for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_BASE_SURFACE_H
#define __PTC_BASE_SURFACE_H

// include files
#include "Base/Index.h"
#include "Base/Types.h"




namespace ptc
{
    namespace Base
    {
        class Surface
        {
            public:

                // virtual destructor
                virtual ~Surface() {};

                // copy to surface
                virtual void copy(Surface &surface) = 0;
                virtual void copy(Surface &surface,const Area &source,const Area &destination) = 0;

                // memory access
                virtual void* lock() = 0;
                virtual void unlock() = 0;

                // load pixels to surface
                virtual void load(const void *pixels,int width,int height,const Format &format,const int32 palette[])                                            = 0;
                virtual void load(const void *pixels,int width,int height,const Area &source,const Area &destination,const Format &format,const int32 palette[]) = 0;

                // save surface pixels
                virtual void save(void *pixels,int width,int height,const Format &format,const int32 palette[]) const											 = 0;
                virtual void save(void *pixels,int width,int height,const Area &source,const Area &destination,const Format &format,const int32 palette[]) const = 0;

                // set palette
                virtual void palette(const int32 palette[]) = 0;

                // data access
                virtual int width() = 0;
                virtual int height() = 0;
                virtual int pitch() = 0;
                virtual const Format& format() = 0;
        };
    }
}




#endif
