//
// Komplex example: temporary test program for komplex asm'98 javademo
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU GPL
//

// include files
#include "ptc.h"




int APIENTRY WinMain(HINSTANCE hInst,HINSTANCE hPrevInst,LPSTR lpCmdLine,int nCmdShow)
{
    try
    {
        // create format
        Format format(32,0xFF<<20,0xFF<<10,0xFF);
 
        // create console
        Console console("Komplex example",512,384,format);

        // create surface
        Surface surface(512,256,format);
        
        // loop until a key is pressed
        while (!console.key())
        {
            // lock surface
            int32 *pixels = (int32*) surface.lock();

            // draw random pixels
            for (int i=0; i<100; i++)
            {
                // get random position
                int x = random(512);
                int y = random(256);

                // get random color
                int r = random(256);
                int g = random(256);
                int b = random(256);

                // draw color [r,g,b] at position [x,y]
                pixels[x+y*512] = (r<<20) + (g<<10) + b;
            }
        
            // unlock surface
            surface.unlock();

            // copy surface to console area
            surface.copy(console,Area(0,0,512,256),Area(0,64,512,320));
            
            // update console
            console.update();
        }

        // done
        return 0;
    }
    catch (Error &error)
    {
        // report error
        error.report();
    }
}
