//
// Win32 Keyboard class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Core/Error.h"
#include "Win32/Keyboard.h"




Win32Keyboard::Win32Keyboard(HWND window,DWORD thread,bool multithreaded) : Win32Hook(window,thread)
{
    // defaults
    m_key = false;
    m_index = 0;
    m_buffer[0] = 0;

    // setup data
    m_multithreaded = multithreaded;
}


Win32Keyboard::~Win32Keyboard()
{
    // destructor
}




bool Win32Keyboard::key()
{
    // enter monitor if multithreaded
    if (m_multithreaded) m_monitor.enter();

    // get keypress flag
    bool key = false;
    if (m_index>0) key = true;

    // leave monitor if multithreaded
    if (m_multithreaded) m_monitor.leave();

    // get key
    return key;
}


int Win32Keyboard::read(Win32Window &window)
{
    // key data
    int key = 0;

    // check if multithreaded
    if (m_multithreaded)
    {
        // check buffer
        if (m_index==0)
        {
            // wait for key event
            m_event.wait();

            // reset event
            m_event.reset();
        }

        // enter monitor
        m_monitor.enter();

        // get key data
        key = m_buffer[m_index-1];

        // decrease index
        m_index--;

        // leave monitor
        m_monitor.leave();
    }
    else
    {
        // update until key is pressed
        while (m_index==0)
        {
            // update window
            window.update();
        }

        // get key data
        key = m_buffer[m_index-1];

        // decrease index
        m_index--;
    }

    // return key data
    return key;
}




LRESULT Win32Keyboard::WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    // handle key message
    if (message==WM_KEYDOWN)
    {
        // enter monitor if multithreaded
        if (m_multithreaded) m_monitor.enter();

        // insert keypress
        m_buffer[m_index] = (int)wParam; 
        
        // inc index
        m_index ++;

        // check multithreaded flag
        if (m_multithreaded)
        {
            // set event
            m_event.set();

            // leave monitor
            m_monitor.leave();
        }
    }

    // done
    return 0;
}
