//
// Image abstraction class for OpenPTC 1.0 C++ API
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The OpenPTC 1.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#ifndef __PTC_X11_IMAGE_H
#define __PTC_X11_IMAGE_H


#include <X11/Xutil.h>
#include <X11/Xlib.h>
#include "ptconfig.h"

class Format;


class X11Image {
public:
  X11Image(Display *display,int screen, int width,int height,Format &format);
  virtual ~X11Image();

  virtual void put(Window w,GC gc,int x,int y) = 0;
  virtual void put(Window w,GC gc,int sx,int sy,int dx,int dy,
		   int width,int height) = 0;

  virtual void* lock() = 0;
  
  virtual int pitch() = 0;

protected:
  unsigned int m_width,m_height;
  Display *m_disp;   
  XImage *m_image;
};


class X11NormalImage : public X11Image {
public:
  X11NormalImage(Display *display,int screen, int width,int height,
		 Format &format);

  ~X11NormalImage();

  virtual void put(Window w,GC gc,int x,int y);
  virtual void put(Window w,GC gc,int sx,int sy,int dx,int dy,int width,
		   int height);

  virtual void* lock();

  virtual int pitch();

private:
  char *m_pixels;
};


#ifdef HAVE_X11_EXTENSIONS_XSHM_H

#include <sys/shm.h>
#include <X11/extensions/XShm.h>

class X11SHMImage : public X11Image {
public:
  X11SHMImage(Display *display,int screen, int width,int height,
		 Format &format);

  ~X11SHMImage();

  virtual void put(Window w,GC gc,int x,int y);
  virtual void put(Window w,GC gc,int sx,int sy,int dx,int dy,int width,
		   int height);

  virtual void* lock();

  virtual int pitch();

private:
  XShmSegmentInfo shminfo;
};

#endif

#endif







