//
// Timer class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_TIMER_H
#define __PTC_TIMER_H

// include files
#include "Types.h"




class Timer
{
    public:

        // setup
        Timer();
        Timer(double time);
        Timer(const Timer &timer);
        ~Timer();

        // set time
        void set(double time);

        // control
        void start();
        void stop();

        // time data
        double time();
        double delta();
        double resolution();
    
        // operators
        Timer& operator =(const Timer &timer);
        bool operator ==(const Timer &timer) const;
        bool operator !=(const Timer &timer) const;

    private:

        // clock time
        double clock();

        // data
        double m_old;
        double m_time;
        double m_start;
        double m_current;
        bool m_running;
};




#endif
