//
// Keyboard example for OpenPTC 1.0 C++ Implementation
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is in the public domain
//

// include files
#include "ptc.h"


int APIENTRY WinMain(HINSTANCE hInst,HINSTANCE hPrevInst,LPSTR lpCmdLine,int nCmdShow)
{
    try
    {
        // create console
        Console console;
        
        // create format
        Format format(32,0x00FF0000,0x0000FF00,0x000000FF);
 
        // open the console
        console.open("Keyboard example",format);

        // create surface matching console dimensions
        Surface surface(console.width(),console.height(),format);
        
        // setup cursor data
        int x = surface.width() / 2;
        int y = surface.height() / 2;
        const int size = surface.width() / 10;
        const Color color(1.0f,1.0f,1.0f);

        // main loop
        while (true)
        {
            // check for key press
            if (console.key())
            {
                // read console key press
                const Key key = console.read();

                // handle cursor keys
                switch (key.code())
                {
                    case Key::LEFT:   x--; break;
                    case Key::RIGHT:  x++; break;
                    case Key::UP:     y--; break;
                    case Key::DOWN:   y++; break;
                }

                // exit when escape is pressed
                if (key.code()==Key::ESCAPE) break;
            }

            // clear surface
            surface.clear();

            // setup cursor area
            Area area(x-size,y-size,x+size,y+size);

            // draw cursor as a quad
            surface.clear(color,area);

            // copy to console
            surface.copy(console);
            
            // update console
            console.update();
        }
    }
    catch (Error &error)
    {
        // report error
        error.report();
    }

    // exit
    return 0;
}
