%define version 1.2.4

Summary: HERMES pixel format conversion library
Name: Hermes
Version: %{version}
Release: 1
Copyright: LGPL
Group: Development/Libraries
Source: http://hermes.terminal.at/Hermes-%{version}.tar.gz
BuildRoot: /tmp/hermes-root
Packager: brn (c.nentwich@cs.ucl.ac.uk)
URL: http://hermes.terminal.at


%description
HERMES is a library designed to convert a source buffer with a specified 
pixel format to a destination buffer with possibly a different format at
the maximum possible speed.

On x86 and MMX architectures, handwritten assembler routines are taking over
the job and doing it lightning fast.

On top of that, HERMES provides fast surface clearing, stretching and some
dithering. Supported platforms are basically all that have an ANSI C
compiler as there is no platform specific code but those are supported: DOS,
Win32 (Visual C), Linux, FreeBSD (IRIX, Solaris are on hold at the moment)


%prep
%setup


%build
CC=egcs CFLAGS="-O6 -mpentium -malign-functions=2 -malign-loops=2 -malign-jumps=2" ./configure --prefix=$RPM_BUILD_ROOT/usr/local
make


%install
make install


%clean
make distclean
rm -rf $RPM_BUILD_ROOT

%files
%doc AUTHORS CHANGES COPYING INSTALL.DOS INSTALL.unix TODO TODO.conversion docs/api/*.htm
%attr(-, root, root) /usr/local/lib/*
%attr(-, root, root) /usr/local/include/*
