//
// Timer example for OpenPTC 1.0 C++ Implementation
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is in the public domain
//

// import classes
import ptc.Error;
import ptc.Format;
import ptc.Surface;
import ptc.Console;



class Timer
{
    public static void main(String argv[])
    {
        try
        {
            // create console
            Console console = new Console();
        
            // create format
            Format format = new Format(32,0x00FF0000,0x0000FF00,0x000000FF);
 
            // open the console
            console.open("Timer example",format);

            // create surface matching console dimensions
            Surface surface = new Surface(console.width(),console.height(),format);

            // create timer
            ptc.Timer timer = new ptc.Timer();

            // start timer
            timer.start();

            // loop until a key is pressed
            while (!console.key())
            {
                // get current time from timer
                final double time = timer.time();
            
                // clear surface
                surface.clear();

                // lock surface pixels
                int pixels[] = (int[]) surface.lock();

                // get surface dimensions
                final int width  = surface.width();
                final int height = surface.height();

                // sine curve parameters
                final float repeats   = 2;
                final float center    = height / 2.0f;
                final float magnitude = height / 3.0f;

                // render a sine curve
                for (int x=0; x<width; x++)
                {
                    // useful pi constant
                    final float pi = 3.1415926f;

                    // rescale 'x' in the range [0,2*pi]
                    final float sx = x / (float) width * 2 * pi;

                    // calculate time at current position
                    final double t = time + sx * repeats;

                    // lookup sine intensity at time 't'
                    final float intensity = (float) Math.sin(t);

                    // convert intensity to a y position on the surface
                    final int y = (int) ( center + intensity * magnitude );

                    // plot pixel on sine curve
                    pixels[x+y*width] = 0x000000FF;
                }

                // unlock surface
                surface.unlock();

                // copy to console
                surface.copy(console);
            
                // update console
                console.update();
            }
        }
        catch (Error error)
        {
            // report error
            error.report();
        }
        
        // exit program
        System.exit(0);
    }
}
