//
// Clip example for OpenPTC 1.0 Java Implementation
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is in the public domain
//

// import classes
import ptc.Area;
import ptc.Error;
import ptc.Format;
import ptc.Surface;
import ptc.Console;



class Clip
{
    public static void main(String argv[])
    {
        try
        {
            // create console
            Console console = new Console();
        
            // create format
            Format format = new Format(32,0x00FF0000,0x0000FF00,0x000000FF);
 
            // open the console
            console.open("Clip example",format);

            // create surface matching console dimensions
            Surface surface = new Surface(console.width(),console.height(),format);
        
            // calculate clip coordinates
            final int x1 = console.width() / 4;
            final int y1 = console.height() / 4;
            final int x2 = console.width() - x1;
            final int y2 = console.height() - y1;

            // create clip area
            Area area = new Area(x1,y1,x2,y2);

            // set clip area
            console.clip(area);

            // loop until a key is pressed
            while (!console.key())
            {
                // lock surface pixels
                int pixels[] = (int[]) surface.lock();

                // get surface dimensions
                final int width  = surface.width();
                final int height = surface.height();

                // draw random pixels
                for (int i=0; i<100; i++)
                {
                    // get random position
                    final int x = random(width);
                    final int y = random(height);

                    // get random color
                    final int r = random(256);
                    final int g = random(256);
                    final int b = random(256);

                    // draw color [r,g,b] at position [x,y]
                    pixels[x+y*width] = (r<<16) + (g<<8) + b;
                }
        
                // unlock surface
                surface.unlock();

                // copy to console
                surface.copy(console);
            
                // update console
                console.update();
            }
        }
        catch (Error error)
        {
            // report error
            error.report();
        }
        
        // exit program
        System.exit(0);
    }

    static int random(int number)
    {
        // random number routine
        return (int) ( Math.random() * number );
    }
}
