//
// Base surface and console interfaces for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_BASE_H
#define __PTC_BASE_H

// include files
#include "Format.h"

// instead of RTTI


class BaseSurface
{
    public:

        // virtual destructor
        virtual ~BaseSurface() {};

        // copy
        virtual void copy(BaseSurface &surface) = 0;

        // memory
        virtual void* lock() = 0;
        virtual void unlock() = 0;

        // palette
        virtual void palette(int32 palette[]) = 0;

        // access
        virtual int width() = 0;
        virtual int height() = 0;
        virtual int pitch() = 0;
        virtual const Format& format() = 0;


};




class BaseConsole : public BaseSurface
{
    public:

        // virtual destructor
        virtual ~BaseConsole() {};

        // console management
        virtual void open(const char title[],int width,int height,
                          Format& format) = 0;
        virtual void close() = 0;

        // synchronization
        virtual void update() = 0;

        // pixel operations
        virtual void write(void *pixels,int width,int height,Format& format,
			   int32 palette[]) = 0;

        // input
        virtual bool key() = 0;
        virtual int read() = 0;

        // access
        virtual const char* name() = 0;
};




#endif
