/* 

   Generic C converter (from 8 bit indexed) for the HERMES library
   Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
   This source code is licensed under the GNU LGPL
  
   Please refer to the file COPYING.LIB contained in the distribution for
   licensing conditions
*/


#include "HermConf.h"
#include "HeadC.h"



/* -------------------------------------------------------------------------

                              NORMAL CONVERTERS
   
   ------------------------------------------------------------------------- */


void ConvertC_index8_32(HermesConverterInterface *iface)
{ int i;
  char8 s_pixel;
  int32 d_pixel;
  char8 *source=(char8 *)iface->s_pixels;
  char8 *dest=(char8 *)iface->d_pixels;

  while (iface->s_height--) {
    
    for(i=0;i<iface->s_width;i++,source++,dest+=4)
    { s_pixel=(char8)*(source);

      d_pixel=iface->lookup[s_pixel];
      WRITE32(dest,d_pixel);
    }
    
    source+=iface->s_add;
    dest+=iface->d_add;
  }

}


void ConvertC_index8_24(HermesConverterInterface *iface)
{ int i;
  char8 s_pixel;
  int32 d_pixel;
  char8 *d_ptr=(char8 *)&d_pixel;
  char8 *source=iface->s_pixels;
  char8 *dest=iface->d_pixels;

  while (iface->s_height--) {

    for(i=0;i<iface->s_width;i++,source++,dest+=3)
    { s_pixel=(char8)*(source);

      d_pixel=iface->lookup[s_pixel];

      *(dest+R_24)=*(d_ptr+R_32);
      *(dest+G_24)=*(d_ptr+G_32);
      *(dest+B_24)=*(d_ptr+B_32);
    
      WRITE32(dest,d_pixel);
    }
    
    source+=iface->s_add;
    dest+=iface->d_add;
  }
}



void ConvertC_index8_16(HermesConverterInterface *iface)
{ int i;
  int32 d_pixel;
  char8 *source=iface->s_pixels;
  char8 *dest=iface->d_pixels;
  int count;

  while (iface->s_height--) {

    count=iface->s_width;

    if(((int)dest&0x3)!=0)
    { WRITE16(dest++,(short16)iface->lookup[*source++]);

      dest++;
      count--;
    }

    for(i=0;i<count>>1;i++,source+=2,dest+=4)
    { d_pixel=DWORD_BYTE0(iface->lookup[(char8)*(source)]);
      d_pixel|=DWORD_BYTE2(iface->lookup[(char8)*(source+1)]);
    
      WRITE32(dest,d_pixel);  
    }

    if(count&1)
    WRITE16(dest,(short16)iface->lookup[*source]);
    
    source+=iface->s_add;
    dest+=iface->d_add;
  }
}



/* -------------------------------------------------------------------------

                              STRETCH CONVERTERS
   
   ------------------------------------------------------------------------- */


void ConvertC_index8_32_S(HermesConverterInterface *iface)
{
  int oldy,x,y=0,count;
  int dy=(iface->s_height<<16)/iface->d_height;
  int dx=(iface->s_width<<16)/iface->d_width;
  char8 *source;
  
  while (iface->d_height--) {

    source=iface->s_pixels;
    count=iface->d_width; 
    x=0;

    while (count--) {
      *((int32*)iface->d_pixels)=iface->lookup[*(source+(x>>16))];
      x+=dx;
      iface->d_pixels+=4;
    }

    /* Go to next destination row */
    iface->d_pixels+=iface->d_add;
    
    /* Calculate amount of rows to move in source surface */
    oldy=y; y+=dy;
    oldy=(y>>16)-(oldy>>16);

    iface->s_pixels+=oldy*iface->s_pitch;
  }
}



/* Quick hack of a index 8 to 16 stretch converter */

void ConvertC_index8_16_S(HermesConverterInterface *iface)
{
  int oldy,x,y=0,count;
  int dy=(iface->s_height<<16)/iface->d_height;
  int dx=(iface->s_width<<16)/iface->d_width;
  char8 *source;
  char8 *dest;

  while (iface->d_height--) {

    source=iface->s_pixels;
    dest=iface->d_pixels;

    /* Do a two pixel at a time loop */

    count=iface->d_width>>1; 
    x=0;

    while (count--) {
      *((int32*)dest)=iface->lookup[*(source+(x>>16))] |
	              (iface->lookup[*(source+((x+dx)>>16))]<<16);
      x+=2*dx;
      dest+=4;
    }

    /* Clean up remaining pixel if odd width */

    if (iface->d_width & 1)
    *((short16*)dest)=(short16)iface->lookup[*(source+(x>>16))];


    /* Go to next destination row */
    iface->d_pixels+=iface->d_pitch;
    
    /* Calculate amount of rows to move in source surface */
    oldy=y; y+=dy;
    oldy=(y>>16)-(oldy>>16);

    iface->s_pixels+=oldy*iface->s_pitch;
  }
}


















