//
// Error class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_ERROR_H
#define __PTC_ERROR_H

// include files
#include "Core/Types.h"
#include "Core/Config.h"
#include "DirectX/Console.h"




class Error
{
    public:

        // setup
        DLLAPI PTCAPI Error();
        DLLAPI PTCAPI Error(const char message[]);
        DLLAPI PTCAPI Error(const char message[],const Error &error);
        DLLAPI PTCAPI Error(const Error &error);
        DLLAPI PTCAPI ~Error();

        // report error
        DLLAPI void PTCAPI report() const;

        // get error message
        DLLAPI const char* PTCAPI message() const;

        // operators
        DLLAPI Error& PTCAPI operator =(const Error &error);
        DLLAPI bool PTCAPI operator ==(const Error &error) const;
        DLLAPI bool PTCAPI operator !=(const Error &error) const;

    protected:

        // friend functions
        friend bool DirectXConsole::option(const char option[]);
        
        // error logging control
        static void logging(bool control);

    private:

        // log error message plus the reason for logging
        void log(const char error[],const char reason[]) const;

        // defaults
        void defaults();
        
        // error message
        char *m_message;

        // static logging data
        static bool m_create;
        static bool m_logging;
};




#endif
