//
// Win32 Hook class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_WIN32_HOOK_H
#define __PTC_WIN32_HOOK_H

// include files
#include <windows.h>
#include "Win32/List.h"
#include "Win32/Monitor.h"




namespace ptc
{
    namespace Win32
    {
        class Hook
        {
            public:
        
                // setup
                Hook(HWND window,DWORD thread);
                ~Hook();

            protected:
    
                // window procedure
                virtual LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam) = 0;

            private:

                // keyboard message hook
                static LRESULT CALLBACK hook(int code,WPARAM wParam,LPARAM lParam);

                // lookup structure
                struct Lookup
                {
                    HWND handle;
                    Hook *hook;
                };
                
                // data
                HHOOK handle;
                Lookup *lookup;

                // static data
                static Monitor monitor;
                static List<Lookup> registry;
        };
    }
}




#endif
