//
// Win32 Hook class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Core/Error.h"
#include "Win32/Hook.h"

// using directive
using namespace ptc::Win32;

// using declarations
using ptc::Core::Error;

// static member data
Monitor Hook::monitor;
List<Hook::Lookup> Hook::registry;




Hook::Hook(HWND window,DWORD thread)
{
    // set window hook
    handle = SetWindowsHookEx(WH_GETMESSAGE,(HOOKPROC)hook,GetModuleHandle(0),thread);

    // check handle
    if (!handle) throw Error("could not set window hook");

    // add to registry
    monitor.enter();
    lookup = new Lookup;
    lookup->hook = this;
    lookup->handle = window;
    registry.add(lookup);
    monitor.leave();
}


Hook::~Hook()
{
    // free window hook
    UnhookWindowsHookEx(handle);

    // remove from registry
    monitor.enter();
    registry.free(lookup);
    monitor.leave();
}




LRESULT CALLBACK Hook::hook(int code,WPARAM wParam,LPARAM lParam)
{
    // get message data
    MSG *message = (MSG*)lParam;

    // enter monitor
    monitor.enter();

    // lookup "Hook" object from "hWnd"
    List<Lookup>::Iterator iterator = registry.first();
    Lookup *lookup = iterator.current();
    while (lookup && lookup->handle!=message->hwnd) lookup = iterator.next();

    // leave monitor
    monitor.leave();

    // check lookup
    if (lookup)
    {
        // call user window procedure
        lookup->hook->WndProc(message->hwnd,message->message,message->wParam,message->lParam);
    
        // call next hook
        CallNextHookEx(lookup->hook->handle,code,wParam,lParam);
    }

    // finished
    return 0;
}
