//
// DirectX Display class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Core/Error.h"
#include "DirectX/Check.h"
#include "DirectX/Display.h"

// using directive
using namespace ptc::DirectX;

// using declarations
using ptc::Core::Error;




Display::Display(LPDIRECTDRAW ddraw)
{
    // setup data
    m_open = false;
    m_ddraw = ddraw;
    m_window = 0;
}


Display::~Display()
{
    // close
    close();
}




void Display::test(const char title[],int width,int height,const ptc::Base::Format &format)
{
    // test display mode
}


void Display::open(HWND window,const char title[],int width,int height,const ptc::Base::Format &format)
{
    // set window
    m_window = window;

    // enter exclusive mode
    check(m_ddraw->SetCooperativeLevel(m_window,DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN | DDSCL_ALLOWMODEX));

    // set display mode
    check(m_ddraw->SetDisplayMode(width,height,format.bits()));

    // set open flag
    m_open = true;
}


void Display::close()
{
    if (m_open)
    {
        // restore display mode
        m_ddraw->RestoreDisplayMode();
        
        // leave exclusive mode
        m_ddraw->SetCooperativeLevel(m_window,DDSCL_NORMAL);

        // clear open flag
        m_open = false;
    }
}
