//
// Core Console implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_CORE_CONSOLE_H
#define __PTC_CORE_CONSOLE_H

// include files
#include "Core/Index.h"
#include "Base/Console.h"

              


namespace ptc
{
    namespace Core
    {
        class Console : public Base::Console
        {
            public:

                // setup
                Console();
                Console(const char title[],int width,int height,const Base::Format &format);
                virtual ~Console();

                // console management
                virtual void open(const char title[],int width,int height,const Base::Format &format);
                virtual void close();

                // synchronization
                virtual void update();

                // pixel operations
                virtual void write(void *pixels,int width,int height,const Base::Format &format,int32 palette[]);

                // keyboard input
                virtual bool key();
                virtual int read();

                // copy
                virtual void copy(Base::Surface &surface);

                // memory
                virtual void* lock();
                virtual void unlock();

                // palette
                virtual void palette(int32 palette[]);

                // data access
                virtual int width();
                virtual int height();
                virtual int pitch();
                virtual const Base::Format& format();
                virtual const char* name();

            private:

                // internal console
                Base::Console *console;
        };
    }
}




#endif
