//
// X11 information dump program for PTC 2.0 C++ API
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#include <typeinfo>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <iostream.h>
#include <stdlib.h>

int main()
{ Display *disp;

  disp=XOpenDisplay(0);
  if(!disp)
  { cout << "Can't open Display" << endl << flush;
    exit(0);
  }

  int screen=DefaultScreen(disp);

  cout << "Default depth: " << (DefaultDepth(disp,screen)) << endl;;
  cout << "Red mask: " << hex << DefaultVisual(disp,screen)->red_mask << endl;
  cout << "Green mask: "  << DefaultVisual(disp,screen)->green_mask << endl;
  cout << "Blue mask: "  << DefaultVisual(disp,screen)->blue_mask << endl << endl << flush;


  XVisualInfo *xvi;
  XVisualInfo xtempl;
  int numfound;
  
  xtempl.screen=screen;
  xvi=XGetVisualInfo(disp,VisualScreenMask,&xtempl,&numfound);

  for(int i=0;i<numfound;i++)
  { cout << endl << "Visual " << i << ":" <<  endl;

    cout << "Depth: " << dec << xvi[i].depth << endl; 

    cout << "Class: ";
    switch(xvi[i].c_class)
    { case 0: cout << "Static Gray"; break;
      case 1: cout << "Gray Scale"; break;
      case 2: cout << "Static Colour"; break;
      case 3: cout << "Pseudo Colour"; break;
      case 4: cout << "True Colour"; break;
      case 5: cout << "Direct Colour"; break;
      default: cout << xvi[i].c_class; 
    }
    cout << endl;
  
    cout << "Red mask: " << hex << xvi[i].red_mask << endl;
    cout << "Green mask: " << hex << xvi[i].green_mask << endl;
    cout << "Blue mask: " << hex << xvi[i].blue_mask << endl;
    cout << "CMap size: " << dec << xvi[i].colormap_size << endl;
    cout << "Bits per RGB: " << xvi[i].bits_per_rgb << endl;
    cout << endl << flush;
  }
  XFree(xvi);

  XPixmapFormatValues *pfv=XListPixmapFormats(disp,&numfound);

  for(int i=0;i<numfound;i++)
  { cout << endl << "Pixmap format " << i << ": " << endl;
    
    cout << "Depth: " << pfv[i].depth << endl ;
    cout << "BPP: " << pfv[i].bits_per_pixel << endl;
    cout << "Pad: " << pfv[i].scanline_pad << endl;
  }

  XFree(pfv);

  XCloseDisplay(disp);
}


