//
// Surface class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Error.h"
#include "Surface.h"
#include <memory.h>




Surface::Surface(int width,int height,const Format& format)
{
    // setup data
    m_width = width;
    m_height = height;
    m_format = format;
    m_pixels = 0;

    // calculate size of pixels
    int size = width * height * format.bits()/8;
 
    // check size
    if (!size) throw Error("zero surface size");

    // allocate pixels
    m_pixels = new char[size];
}


Surface::~Surface()
{
    // free surface
    delete m_pixels;
}




void Surface::copy(BaseSurface &surface)
{
    try
    {
        // cast to console
        BaseConsole &console = dynamic_cast<BaseConsole&>(surface);

        // write surface pixels to console
        console.write(m_pixels,m_width,m_height,m_format,m_palette);
    }
    catch (bad_cast)
    {
        // error message
        throw Error("surface to surface copy is not implemented");
    }
}




void* Surface::lock()
{
    // lock
    return m_pixels;
}


void Surface::unlock()
{
    // unlock
}




void Surface::palette(int32 palette[])
{
    // set palette
    memcpy(m_palette,palette,256*4);
}




int Surface::width()
{
    // get width
    return m_width;
}


int Surface::height()
{
    // get height
    return m_height;
}


int Surface::pitch()
{
    // get pitch
    return m_width * m_format.bits()/8;
}


const Format& Surface::format()
{
    // get format
    return m_format;
}
