//
// X11 Console implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions 
//


#ifndef __PTC_CONSOLE_H
#define __PTC_CONSOLE_H

#define PTC_X11_NODGA 1
#define PTC_X11_LEAVE_DISPLAY 2
#define PTC_X11_LEAVE_WINDOW 4

// include files
#include "Base.h"
#include "X11Display.h"
#include <X11/Xlib.h>

class Console : public BaseConsole
{
    public:
        
        // setup
        Console();
        Console(const char title[],int width,int height,Format& format,
		long flags=0);
        virtual ~Console();

        // console management
	virtual void open(const char title[],int width,int height,
			  Format& format)
	{ open(title,width,height,format,0);
	}

        void open(const char title[],int width,int height,
			  Format& format,long flags);
	void open(Display *disp,int screen,Window w,Format& format,
		  long flags=0);

        virtual void close();


        // synchronization
        virtual void update();

        // pixel operations
        virtual void write(void *pixels,int width,int height,Format& format,
			   int32 palette[]);

        // input
        virtual bool key();
        virtual int read();

        // copy
        virtual void copy(BaseSurface &surface);
        
        // memory
        virtual void* lock();
        virtual void unlock();

        // palette
        virtual void palette(int32 palette[]);

        // data access
        virtual int width();
        virtual int height();
        virtual int pitch();
        virtual const Format& format();
        virtual const char* name();


        // functions specific to the x11 implementation
	// set console X11 flags
	void flags(long mask) { x11disp->flags(mask); }

	// check if we are in windowed mode
	bool isWindow();

    private:
	bool checkDGA(int width,int height,Display *disp,int screen);

	X11Display *x11disp;
};


inline void Console::update()
{ x11disp->update();
}

inline void Console::write(void *pixels,int width,int height,Format& format,
			   int32 palette[])
{ x11disp->write(pixels,width,height,format,palette);
}

inline bool Console::key()
{ return x11disp->key();
}

inline int Console::read()
{ return x11disp->read();
}

inline void* Console::lock()
{ return x11disp->lock();
}

inline void Console::unlock()
{ x11disp->unlock();
}

inline void Console::palette(int32 palette[])
{ x11disp->palette(palette);
}

inline int Console::width()
{ return x11disp->width();
}

inline int Console::height()
{ return x11disp->height();
}

inline const Format& Console::format()
{ return x11disp->format();
}

inline int Console::pitch()
{ return x11disp->pitch();
}

inline const char* Console::name()
{ return "X11";
}

#endif
