#
# x86 format converters for HERMES
# Some routines Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
# This source code is licensed under the GNU LGPL
# 
# Please refer to the file COPYING.LIB contained in the distribution for
# licensing conditions          
#
# Most routines are (c) Glenn Fiedler (ptc@gaffer.org), used with permission
# 

.globl _ConvertX86
.globl _x86return

.globl _Hermes_X86_CPU


.data

cpu_flags: .long 0


.text

## _ConvertX86:  
## [ESP+8] ConverterInfo*
## --------------------------------------------------------------------------
## ConverterInfo (ebp+..)
##   0: void *s_pixels
##   4: int s_width
##   8: int s_height
##  12: int s_add
##  16: void *d_pixels
##  20: int d_width
##  24: int d_height
##  28: int d_add
##  32: void (*converter_function)() 
##  36: int32 *lookup

_ConvertX86: 
        pushl %ebp
        movl %esp,%ebp

        movl 8(%ebp),%eax

        cmpl $0,4(%eax)
        je endconvert

        movl %eax,%ebp

        movl (%ebp),%esi
        movl 16(%ebp),%edi

y_loop: 
        movl 4(%ebp),%ecx

        jmp *32(%ebp)

_x86return: 
        addl 12(%ebp),%esi
        addl 28(%ebp),%edi

        decl 8(%ebp)
        jnz y_loop


        popl %ebp

endconvert: 
        ret



## Hermes_X86_CPU returns the CPUID flags in eax

_Hermes_X86_CPU: 
        pushf
        popl %eax

        movl %eax,%ecx

        xorl $0x040000,%eax
        pushl %eax

        popf
        pushf

        popl %eax
        xorl %ecx,%eax
        jz _Hermes_X86_CPU.L1   # Processor is 386

        pushl %ecx
        popf

        movl %ecx,%eax
        xorl $0x200000,%eax

        pushl %eax
        popf
        pushf

        popl %eax
        xorl %ecx,%eax
        je _Hermes_X86_CPU.L1

        pusha

        movl $1,%eax
        cpuid

        movl %edx,cpu_flags

        popa

        movl cpu_flags,%eax

_Hermes_X86_CPU.L1: 
        ret
