//
// Win32 Window class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_WIN32_WINDOW_H
#define __PTC_WIN32_WINDOW_H

// include files
#include "Win32/Index.h"
#include <windows.h>




namespace ptc
{
    namespace Win32
    {
        class Window
        {
            public:

                // setup
                Window(HWND window);
                Window(const char title[],unsigned extra,unsigned style,int show,int x,int y,int width,int height,void *data=0);
                ~Window();
        
                // access
                HWND handle();
                DWORD thread();

            private:

                // internals
                void defaults();
                void close();

                // window internals
                static void WINAPI ThreadFunction(Window *owner);
                static LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);
        
                // window data
                HWND m_window;
                HCURSOR m_cursor;
                HANDLE m_event;
                HANDLE m_thread;
                DWORD m_id;

                // window data
                char name[1024];    // window class name
                char title[1024];   // window title
                unsigned extra;     // window style extra
                unsigned style;     // window style
                int show;           // window show command
                int x;              // window x
                int y;              // window y
                int width;          // window width
                int height;         // window height
                void *data;         // creation data
        };
    }
}




#endif
