//
// Core Surface implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include <memory.h>
#include <typeinfo.h>
#include "Base/Types.h"
#include "Base/Console.h"
#include "Core/Error.h"
#include "Core/Surface.h"

// using directive
using namespace ptc::Core;




Surface::Surface(int width,int height,const ptc::Base::Format &format)
{
    // setup data
    m_width = width;
    m_height = height;
    m_format = format;
    m_pixels = 0;

    // calculate size of pixels
    int size = width * height * format.bits()/8;

    // check size
    if (!size) throw Error("zero surface size");

    // allocate pixels
    m_pixels = new char8[size];
}


Surface::~Surface()
{
    // free surface
    delete m_pixels;
}




void Surface::copy(ptc::Base::Surface &surface)
{
    // load surface pixels to other surface
    surface.load(m_pixels,m_width,m_height,m_format,m_palette);
}


void Surface::copy(ptc::Base::Surface &surface,const ptc::Base::Area &source,const ptc::Base::Area &destination)
{
    // load surface pixels to other surface
    throw Error("surface area copy is not implemented");
}




void* Surface::lock()
{
    // lock
    return m_pixels;
}


void Surface::unlock()
{
    // unlock
}




void Surface::load(const void *pixels,int width,int height,const ptc::Base::Format &format,const int32 palette[])
{
    // load pixels to surface
    throw Error("surface load is not implemented");
}


void Surface::load(const void *pixels,int width,int height,const ptc::Base::Format &format,const int32 palette[],const ptc::Base::Area &area)
{
    // load pixels to surface
    throw Error("surface area is not implemented");
}




void Surface::save(void *pixels,int width,int height,const ptc::Base::Format &format,const int32 palette[]) const
{
    // save surface pixels
    throw Error("surface save is not implemented");
}


void Surface::save(void *pixels,int width,int height,const ptc::Base::Format &format,const int32 palette[],const ptc::Base::Area &area) const
{
    // save surface pixels
    throw Error("surface save is not implemented");
}




void Surface::palette(const int32 palette[])
{
    // set palette
    memcpy(m_palette,palette,256*4);
}




int Surface::width()
{
    // get width
    return m_width;
}


int Surface::height()
{
    // get height
    return m_height;
}


int Surface::pitch()
{
    // get pitch
    return m_width * m_format.bits()/8;
}


const ptc::Base::Format& Surface::format()
{
    // get format
    return m_format;
}
