//
// X11 Console implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions 
//


#ifndef __PTC_CONSOLE_H
#define __PTC_CONSOLE_H


// include files

#include <X11/Xlib.h>
#include "Core/Base.h"
#include "Core/Key.h"
#include "Display.h"


class Area;


enum {
  PTC_X11_NODGA = 1,
  PTC_X11_LEAVE_DISPLAY = 2,
  PTC_X11_LEAVE_WINDOW = 4,
  PTC_X11_PEDANTIC_DGA = 8,
  PTC_X11_DITHER = 16
};


class Console : public BaseConsole
{
    public:
        
        // setup
        Console();
        ~Console();

	// console option string
	virtual bool option(const char str[]);

        // open routines, pick and mix :)
	virtual void open(const char title[]);
	virtual void open(const char title[],const Format& format);
	virtual void open(const char title[],int width,int height,
			  const Format& format);
	void open(Display *disp,int screen,Window w,const Format& format);
	void open(Display *disp,int screen,Window window,const Format& format,
		  int x,int y,int w,int h);

        virtual void close();


        // synchronization
	virtual void flush() { }
	virtual void finish() { }
        virtual void update() { x11disp->update(); }
	virtual void update(const Area &area) { x11disp->update(area); }

        // input
        virtual bool key() { return x11disp->key(); }
        virtual Key read() { return x11disp->read(); }

        // copy
        virtual void copy(BaseSurface &surface);
	virtual void copy(BaseSurface &surface,const Area &source,
			  const Area &destination);

        // memory
        virtual void* lock() { return x11disp->lock(); }
        virtual void unlock() { x11disp->unlock(); }


        // load pixels to console
        virtual void load(const void *pixels,int width,int height,
			  const Format &format,const Palette &palette);
        virtual void load(const void *pixels,int width,int height,
			  const Area &source,const Area &destination,
			  const Format &format,const Palette &palette);

        // save console pixels
        virtual void save(void *pixels,int width,int height,
			  const Format &format,const Palette &palette);
        virtual void save(void *pixels,int width,int height,
			  const Area &source,const Area &destination,
			  const Format &format,const Palette &palette);

	// clear surface
	virtual void clear();
	virtual void clear(const Color &color) { x11disp->clear(color); }
	virtual void clear(const Color &color,const Area &area)
          	          { x11disp->clear(color,area); }             

        // palette
        virtual void palette(const Palette &palette) 
	{ x11disp->palette(palette); }
        virtual const Palette& palette() const { return x11disp->palette(); }

        // data access
        virtual int width() const { return x11disp->width(); }
        virtual int height() const { return x11disp->height(); }
        virtual int pitch() const { return x11disp->pitch(); }
        virtual const Format& format() const { return x11disp->format(); }
        virtual const char* name() const;


        // --- functions specific to the x11 implementation ---

	// check if we are in windowed mode
	bool isWindow() const;

	// return the display we are using
        Display *getX11Display() const { return x11disp->getX11Display(); }

	// return the screen we are using
	int getX11Screen() const { return x11disp->getX11Screen(); }

	// return the window we are using (0, if in DGA mode) 
	Window getX11Window() const { return x11disp->getX11Window(); }
        
    private:

        // disallow console assignment
	Console(const Console &console);
        Console& operator =(const BaseSurface &other);

        // configure console options
        void configure(const char filename[]);

	X11Display *x11disp;
	long m_flags;
};


#endif
