//
// Error class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Error.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>




Error::Error()
{
    // defaults
    defaults();
}


Error::Error(const char message[])
{
    // allocate new message
    m_message = new char[strlen(message)+1];

    // set error message
    strcpy(this->m_message,message);
}


Error::Error(const char message[],const Error &error)
{
    // calculate length of composite error message string
    int length = strlen(message) + strlen("\n") + strlen(error.m_message) + 1;

    // allocate new message
    m_message = new char[length];

    // setup composite error message
    sprintf(m_message,"%s\n%s",message,error.m_message);
}


Error::Error(const Error &error)
{
    // defaults
    defaults();

    // assignment
    *this = error;
}


Error::~Error()
{
    // free message
    delete[] m_message;
}




void Error::report() const
{
    // report error
    fprintf(stderr,"error: %s\n",m_message);

    // exit
    exit(1);
}




const char* Error::message() const
{
    // get message
    return m_message;
}




Error& Error::operator =(const Error &error)
{
    // check for self assignment
    if (this==&error) throw Error("self assignment is not allowed");
        
    // check if error message string will fit in this one
    if (strlen(error.m_message)>strlen(m_message))
    {
        // free old message
        delete[] m_message;

        // allocate new message
        m_message = new char[strlen(error.m_message)];
    }

    // copy error message string
    strcpy(m_message,error.m_message);

    // finished
    return *this;
}


bool Error::operator ==(const Error &error) const
{
    // is equal to
    if (!strcmp(error.m_message,m_message)) return true;
    else return false;
}


bool Error::operator !=(const Error &error) const
{
    // not equal to
    return !(*this==error);
}




void Error::defaults()
{
    // defaults
    m_message = new char[1];
    m_message[0] = 0;
}




