//
// Copy class for PTC 2.0 C++ API
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#ifndef __PTC_COPY_H
#define __PTC_COPY_H

// include files
#include "Types.h"
#include "Index.h"

extern "C" {
#include "Hermes/Hermes.h"
}

class Copy 
{ 
   public:
  
       // default constructor
       Copy();
       
       // destructor
       ~Copy();

       // set pixel formats
       void request(const Format &source,const Format &destination);

       // set source palette
       void palette(const Palette &source,const Palette &destination);

       // copy pixels
       void copy(const void *s_pixels,int s_x,int s_y,int s_width,
		 int s_height,int s_pitch,void *d_pixels,int d_x,int d_y,
		 int d_width,int d_height,int d_pitch);

       // copy option string
       bool option(const char option[]);

private:
       // Will you keep your hands off copying Copy? :)
       Copy(const Copy &other);
       Copy& operator=(const Copy &other);

       // Internal handle for HERMES access
       HermesHandle m_handle;

       // Internal flags
       long m_flags;
};




#endif

